<?php get_header(); ?>
 
	<div id="container">
		<div class="containment">
            <div id="content">
 
				<?php if ( have_posts() ) : ?>

					<h1 class="page-title"><?php _e( 'Search Results for: ', 'hbd-theme' ); ?><span><?php the_search_query(); ?></span></h1>                          

					<?php while ( have_posts() ) : the_post() ?>

						<div id="post-<?php the_ID(); ?>" class="multiple-posts">
							<?php if(!empty(get_the_post_thumbnail_url())) { ?>
								<div class="featured-image">
									<a href="<?php the_permalink(); ?>" title="<?php printf( __('Permalink to %s', 'hbd-theme'), the_title_attribute('echo=0') ); ?>" rel="bookmark"><img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>" /></a>
								</div>
							<?php } ?>
							<h2 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>

							<?php if ( $post->post_type == 'post' ) { ?>
								<div class="entry-meta">
									<span><?php _e('Published ', 'hbd-theme'); ?></span>
									<span class="date"><?php the_time( get_option( 'date_format' ) ); ?></span>
								</div>
							<?php } ?>

							<div class="entry-summary">
								<?php the_excerpt( __( 'Continue reading <span class="meta-nav">&raquo;</span>', 'hbd-theme' )  ); ?>
							</div>
						</div>

					<?php endwhile; ?>

				<?php global $wp_query; $total_pages = $wp_query->max_num_pages; if ( $total_pages > 1 ) { ?>
					<div id="nav-below" class="navigation">
						<div class="nav-previous"><?php next_posts_link(__( '<span class="meta-nav">&laquo;</span> Older posts', 'hbd-theme' )) ?></div>
						<div class="nav-next"><?php previous_posts_link(__( 'Newer posts <span class="meta-nav">&raquo;</span>', 'hbd-theme' )) ?></div>
					</div>
				<?php } ?>            

				<?php else : ?>

					<div class="post no-results not-found">
						<h2 class="entry-title"><?php _e( 'Nothing Found', 'hbd-theme' ) ?></h2>
						<div class="entry-content">
							<p><?php _e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'hbd-theme' ); ?></p>
						</div>
					</div>

				<?php endif; ?>           
 
            </div>
			<?php get_sidebar(); ?>
        </div>
	</div>
 
<?php get_footer(); ?>