<?php get_header(); ?>
<div id="container">
	<div class="containment">
		<div id="content">
			
			<?php while ( have_posts() ) : the_post() ?>

				<div id="post" class="multiple-posts">
					<?php if(!empty(get_the_post_thumbnail_url())) { ?>
						<div class="featured-image">
							<a href="<?php the_permalink(); ?>" title="<?php printf( __('Permalink to %s', 'hbd-theme'), the_title_attribute('echo=0') ); ?>" rel="bookmark"><img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>" /></a>
						</div>
					<?php } ?>
					
					<h2 class="title"><a href="<?php the_permalink(); ?>" title="<?php printf( __('Permalink to %s', 'hbd-theme'), the_title_attribute('echo=0') ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>

					<div class="entry-date">
						<span><?php _e('Published ', 'hbd-theme'); ?></span>
						<span class="date"><?php the_time( get_option( 'date_format' ) ); ?></span>
					</div>

					<div class="post-content">
						<?php the_excerpt( __( 'Continue reading <span class="meta-nav">&raquo;</span>', 'hbd-theme' )  ); ?>
					</div>
				</div>

			<?php endwhile; ?>
			
			<?php global $wp_query; $total_pages = $wp_query->max_num_pages; if ( $total_pages > 1 ) { ?>
				<div id="nav-below" class="navigation">
					<?php next_posts_link(__( '<span class="meta-nav">&laquo;</span> Older posts', 'hbd-theme' )) ?> <span style="color: #bbb;">&#8226;</span> <?php previous_posts_link(__( 'Newer posts <span class="meta-nav">&raquo;</span>', 'hbd-theme' )) ?>
				</div>
			<?php } ?>
		</div>

		<?php get_sidebar(); ?>
	</div>
</div>
 
<?php get_footer(); ?>