<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head profile="http://gmpg.org/xfn/11">
    <title><?php
        if ( is_single() ) { single_post_title(); }
        elseif ( is_home() || is_front_page() ) { bloginfo('name'); print ' | '; bloginfo('description'); get_page_number(); }
        elseif ( is_page() ) { single_post_title(''); }
        elseif ( is_search() ) { bloginfo('name'); print ' | Search results for ' . wp_specialchars($s); get_page_number(); }
        elseif ( is_404() ) { bloginfo('name'); print ' | Not Found'; }
        else { bloginfo('name'); wp_title('|'); get_page_number(); }
    ?></title>
 
    <meta http-equiv="content-type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
 
    <link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>" />
 
    <?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>

    <?php wp_head(); ?>
 
    <link rel="alternate" type="application/rss+xml" href="<?php bloginfo('rss2_url'); ?>" title="<?php printf( __( '%s latest posts', 'hbd-theme' ), wp_specialchars( get_bloginfo('name'), 1 ) ); ?>" />
    <link rel="alternate" type="application/rss+xml" href="<?php bloginfo('comments_rss2_url') ?>" title="<?php printf( __( '%s latest comments', 'hbd-theme' ), wp_specialchars( get_bloginfo('name'), 1 ) ); ?>" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
	<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/css/styles.css"></script>
	<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/main.js"></script>
	<meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body>
<div id="wrap">
    <div id="header">
    	<div id="logo">
        	<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo get_template_directory_uri(); ?>/img/logo.png" alt="Car Website Logo" /></a>
        </div>
        <nav>
            <?php wp_nav_menu( array( 'menu'=>'Nav', 'sort_column' => 'menu_order', 'container_class' => 'menu-header' ) ); ?>
        </nav>
        <div class="alignright">
            <div class="buttons">
                <div id="nav-button" class="button-container">
                  <div class="bar1"></div>
                  <div class="bar2"></div>
                  <div class="bar3"></div>
                </div>
                <div id="nav-close"></div>
            </div>
        </div>
        <div class="clear"></div>
    </div>
	
	<?php if((!is_home()) && (!is_front_page())) { ?>
		<?php 
		if(!empty(get_the_post_thumbnail_url())) {
			$thumb = get_the_post_thumbnail_url();
		} else {
			$thumb = get_template_directory_uri() . '/img/image.jpg';
		}
		?>
		<div class="header-image parallax" style="background-image: url(<?php echo $thumb; ?>)">
		    <div class="gradient"></div>
			<div class="header-title"><?php the_title(); ?></div>
		</div>
	<?php } elseif(!is_front_page()) { ?>
		<div class="header-image parallax" style="background-image: url(<?php echo get_template_directory_uri(); ?>/img/image.jpg);">
		    <div class="gradient"></div>
			<div class="header-title">Our Blog</div>
		</div>
	<?php } ?>
 
    <div id="main">