<?php 
/* Template Name: Full Width */ 
?>
<?php get_header(); ?>
	<div id="container">
		<div class="containment">
			<div id="content" class="full-width">

				<?php the_post(); ?>
				<div id="post">
					<h1 class="title"><?php the_title(); ?></h1>
					<?php the_content(); ?>
					<?php
					$args = array(
						'post_type'      => 'page',
						'posts_per_page' => -1,
						'post_parent'    => $post->ID,
						'order'          => 'ASC',
						'orderby'        => 'menu_order'
					 );
					$parent = new WP_Query( $args );
					if ( $parent->have_posts() ) : ?>
						<div class="clear"></div>
						<?php while ( $parent->have_posts() ) : $parent->the_post(); ?>
							<div id="parent-<?php the_ID(); ?>" class="child-page">
								<?php
								if(!empty(get_the_post_thumbnail_url())) {
								?>
									<div class="featured-image">
										<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>" /></a>
									</div>
								<?php
								}
								?>
								<h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h3>
							</div>
						<?php endwhile; ?>
					<?php endif; wp_reset_query(); ?>
				</div>        

			</div>
		</div>
	</div>
<?php get_footer(); ?>