<?php get_header(); ?>
 
	<div id="container">
		<div class="containment">
            <div id="content">
 
                <?php the_post(); ?>          

				<h1 class="page-title author"><?php printf( __( 'Author Archives: <span class="vcard">%s</span>', 'hbd-theme' ), "<a class='url fn n' href='$authordata->user_url' title='$authordata->display_name' rel='me'>$authordata->display_name</a>" ) ?></h1>
				<?php $authordesc = $authordata->user_description; if ( !empty($authordesc) ) echo apply_filters( 'archive_meta', '<div class="archive-meta">' . $authordesc . '</div>' ); ?>

				<?php rewind_posts(); ?>           

				<?php while ( have_posts() ) : the_post(); ?>
				
					<div id="post-<?php the_ID(); ?>" class="multiple-posts">
						<?php if(!empty(get_the_post_thumbnail_url())) { ?>
							<div class="featured-image">
								<a href="<?php the_permalink(); ?>" title="<?php printf( __('Permalink to %s', 'hbd-theme'), the_title_attribute('echo=0') ); ?>" rel="bookmark"><img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>" /></a>
							</div>
						<?php } ?>
						<h2 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>

						<?php if ( $post->post_type == 'post' ) { ?>
							<div class="entry-meta">
								<span><?php _e('Published ', 'hbd-theme'); ?></span>
								<span class="date"><?php the_time( get_option( 'date_format' ) ); ?></span>
							</div>
						<?php } ?>

						<div class="entry-summary">
							<?php the_excerpt( __( 'Continue reading <span class="meta-nav">&raquo;</span>', 'hbd-theme' )  ); ?>
						</div>
					</div>

				<?php endwhile; ?>            

				<?php global $wp_query; $total_pages = $wp_query->max_num_pages; if ( $total_pages > 1 ) { ?>
					<div id="nav-below" class="navigation">
						<?php previous_post_link( '%link', '<span class="meta-nav">&laquo;</span> %title' ) ?> <span style="color: #bbb;">&#8226;</span> <?php next_post_link( '%link', '%title <span class="meta-nav">&raquo;</span>' ) ?>
					</div>
				<?php } ?>                   
 
            </div>
			<?php get_sidebar(); ?>
        </div>
	</div>
 
<?php get_footer(); ?>