<?php

class ITSEC_Malware {

	function run() {
		global $itsec_malware;

		$itsec_malware = $this;

		add_filter( 'itsec_logger_modules', array( $this, 'itsec_logger_modules' ) );
		add_filter( 'itsec_sync_modules', array( $this, 'itsec_sync_modules' ) ); //register sync modules

	}

	/**
	 * Register malware for logger
	 *
	 * @since 4.4
	 *
	 * @param  array $logger_modules array of logger modules
	 *
	 * @return array                   array of logger modules
	 */
	public function itsec_logger_modules( $logger_modules ) {
		$logger_modules['malware'] = array(
			'type'     => 'malware',
			'function' => __( 'Malware Scan', 'it-l10n-ithemes-security-pro' ),
		);

		return $logger_modules;

	}

	/**
	 * Register malware for Sync
	 *
	 * @param  array $sync_modules array of malware modules
	 *
	 * @return array                   array of logger modules
	 */
	public function itsec_sync_modules( $sync_modules ) {

		$sync_modules['malware'] = array(
			'verbs'      => array(
				'itsec-do-malware-scan'      => 'Ithemes_Sync_Verb_ITSEC_Malware_Do_Scan',
				'itsec-get-malware-scan-log' => 'Ithemes_Sync_Verb_ITSEC_Get_Malware_Scan_Log',
			),
			'everything' => 'itsec-get-malware-scan-log',
			'path'       => dirname( __FILE__ ),
		);

		return $sync_modules;

	}

}
